#ifndef RINGSET_CONTROL_H
#define RINGSET_CONTROL_H

#include "smx_dll.h"

#ifdef __cplusplus
	extern "C" {
#endif

#define RINGSET_CONTROL_PERFORM_ACTION 0x1

#define RINGSET_CONTROL_FBTH0_HIGH 0x1
#define RINGSET_CONTROL_FBTH1_HIGH 0x2
#define RINGSET_CONTROL_FBTH2_HIGH 0x4
#define RINGSET_CONTROL_FBTH3_HIGH 0x8

#define RINGSET_CONTROL_MESSAGE_SIZE 2048

__declspec(dllexport) p_smx_dll_device_spec* smx_dll_get_supported_devices(void);
__declspec(dllexport) p_smx_dll_device_spec  smx_dll_get_device_spec(char* name, SMX_DLL_UINT32 version);

typedef struct t_ringset_control_input_bus_pointers {

	p_smx_dll_bus CLK_bus_p;
	p_smx_dll_bus FBTH_bus_p;
	p_smx_dll_bus VINTH_bus_p;

} s_ringset_control_input_bus_pointers, *p_ringset_control_input_bus_pointers;

typedef struct t_ringset_control_output_bus_pointers {

	p_smx_dll_bus RSET_bus_p;

} s_ringset_control_output_bus_pointers, *p_ringset_control_output_bus_pointers;

typedef struct t_ringset_control_parameter_values {

	SMX_DLL_UINT64 IC;
	SMX_DLL_UINT64 RSET_MIN_LL;
	SMX_DLL_UINT64 RSET_MAX_LL;
	SMX_DLL_UINT64 RSET_MIN_HL;
	SMX_DLL_UINT64 RSET_MAX_HL;
	SMX_DLL_DOUBLE WAKE_INTERVAL;
	SMX_DLL_DOUBLE OUTPUT_DELAY;

} s_ringset_control_parameter_values, *p_ringset_control_parameter_values;

typedef struct t_ringset_control_default_pointers {

	p_ringset_control_input_bus_pointers	input_bus_pointers_p;
	p_ringset_control_output_bus_pointers	output_bus_pointers_p;
	p_ringset_control_parameter_values	parameter_values_p;

} s_ringset_control_default_pointers, *p_ringset_control_default_pointers;

/*
 * ringset_control_setup
 *
 *	This function is defined in ringset_control_setup.c
 */
void
	ringset_control_setup(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * ringset_control_set_initial_condition
 *
 *	This function is defined in ringset_control_set_initial_condition.c
 */
void
	ringset_control_set_initial_condition(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * ringset_control_action
 *
 *	This function is defined in ringset_control_action.c
 */
void
	ringset_control_action(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * ringset_control_teardown
 *
 *	This function is defined in ringset_control_teardown.c
 */
void
	ringset_control_teardown(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * ringset_control_assign_default_pointers
 *
 *	This function is defined in ringset_control.c
 */
SMX_DLL_ERROR
	ringset_control_assign_default_pointers(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * ringset_control_instantiate_default_pointers
 *
 *	This function is defined in ringset_control.c
 */
SMX_DLL_ERROR
	ringset_control_instantiate_default_pointers(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
		,
		p_ringset_control_default_pointers *result
	);

#ifdef __cplusplus
}
#endif

#endif
